/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.NetworkNodeDiskDrive;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator.StorageDiskFluidManipulatorWrapper;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator.StorageDiskItemManipulatorWrapper;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerProxy;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileDiskManipulator;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.FilterType;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.config.IUpgradeContainer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeDiskManipulator
extends NetworkNode
implements IRSFilterConfigProvider,
IStorageDiskContainerContext,
IUpgradeContainer {
    public static final String ID = "disk_manipulator";
    public static final int IO_MODE_INSERT = 0;
    public static final int IO_MODE_EXTRACT = 1;
    private static final String NBT_IO_MODE = "IOMode";
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterModeBlackAndWhitelist().filterModeBlacklist().allowedFilterTypeItemsAndFluids().filterTypeItems().filterSizeNine().compareDamageAndNbt().customFilterTypeSupplier(ft -> this.world.field_72995_K ? FilterType.values()[TileDiskManipulator.TYPE.getValue()] : ft).build();
    private int ioMode = 0;
    private final IStorageDisk<ItemStack>[] itemDisks = new IStorageDisk[6];
    private final IStorageDisk<FluidStack>[] fluidDisks = new IStorageDisk[6];
    private final ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, new ListenerNetworkNode(this), new int[]{2, 4}){

        @Override
        public int getItemInteractCount() {
            int count = super.getItemInteractCount();
            if (NetworkNodeDiskManipulator.this.config.isFilterTypeFluid()) {
                count *= 1000;
            }
            return count * 25;
        }
    };
    private final ItemHandlerBase inputDisks = new ItemHandlerBase(3, new ListenerNetworkNode(this), new Predicate[]{NetworkNodeDiskDrive.VALIDATOR_STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!((NetworkNodeDiskManipulator)NetworkNodeDiskManipulator.this).world.field_72995_K) {
                StackUtils.createStorages(NetworkNodeDiskManipulator.this.world, this.getStackInSlot(slot), slot, NetworkNodeDiskManipulator.this.itemDisks, NetworkNodeDiskManipulator.this.fluidDisks, s -> new StorageDiskItemManipulatorWrapper(NetworkNodeDiskManipulator.this, (IStorageDisk<ItemStack>)s), s -> new StorageDiskFluidManipulatorWrapper(NetworkNodeDiskManipulator.this, (IStorageDisk<FluidStack>)s));
                WorldUtils.updateBlock(NetworkNodeDiskManipulator.this.world, NetworkNodeDiskManipulator.this.pos);
            }
        }
    };
    private final ItemHandlerBase outputDisks = new ItemHandlerBase(3, new ListenerNetworkNode(this), new Predicate[]{NetworkNodeDiskDrive.VALIDATOR_STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!((NetworkNodeDiskManipulator)NetworkNodeDiskManipulator.this).world.field_72995_K) {
                StackUtils.createStorages(NetworkNodeDiskManipulator.this.world, this.getStackInSlot(slot), 3 + slot, NetworkNodeDiskManipulator.this.itemDisks, NetworkNodeDiskManipulator.this.fluidDisks, s -> new StorageDiskItemManipulatorWrapper(NetworkNodeDiskManipulator.this, (IStorageDisk<ItemStack>)s), s -> new StorageDiskFluidManipulatorWrapper(NetworkNodeDiskManipulator.this, (IStorageDisk<FluidStack>)s));
                WorldUtils.updateBlock(NetworkNodeDiskManipulator.this.world, NetworkNodeDiskManipulator.this.pos);
            }
        }
    };
    private final ItemHandlerProxy disks = new ItemHandlerProxy((IItemHandler)this.inputDisks, (IItemHandler)this.outputDisks);

    public NetworkNodeDiskManipulator(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.diskManipulatorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void updateNetworkNode() {
        int slot;
        super.updateNetworkNode();
        if (!this.canUpdate() || this.ticks % this.upgrades.getSpeed() != 0) {
            return;
        }
        if (this.config.isFilterTypeItem()) {
            for (slot = 0; slot < 3 && (this.itemDisks[slot] == null || this.isItemDiskDone(this.itemDisks[slot], slot)); ++slot) {
            }
            if (slot == 3) {
                return;
            }
            IStorageDisk<ItemStack> storage = this.itemDisks[slot];
            if (this.ioMode == 0) {
                this.insertItemIntoNetwork(storage);
            } else if (this.ioMode == 1) {
                this.extractItemFromNetwork(storage, slot);
            }
        } else if (this.config.isFilterTypeFluid()) {
            while (slot < 3 && (this.fluidDisks[slot] == null || this.isFluidDiskDone(this.fluidDisks[slot], slot))) {
                ++slot;
            }
            if (slot == 3) {
                return;
            }
            IStorageDisk<FluidStack> storage = this.fluidDisks[slot];
            if (this.ioMode == 0) {
                this.insertFluidIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractFluidFromNetwork(storage, slot);
            }
        }
    }

    private void insertItemIntoNetwork(IStorageDisk<ItemStack> storage) {
        ObjectArrayList entries = new ObjectArrayList(storage.getEntries());
        for (StackListEntry stack : entries) {
            StackListResult extracted;
            if (!this.config.acceptsItem((ItemStack)stack.getStack()) || (extracted = storage.extract((ItemStack)stack.getStack(), this.upgrades.getItemInteractCount(), this.config.getCompare(), Action.PERFORM)) == null) continue;
            StackListResult<ItemStack> remainder = this.network.insertItem((ItemStack)extracted.getStack(), extracted.getCount(), Action.PERFORM);
            if (remainder == null) break;
            storage.insert(remainder.getStack(), remainder.getCount(), Action.PERFORM);
        }
    }

    private boolean isItemDiskDone(IStorageDisk<ItemStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0L) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ObjectArrayList entries = new ObjectArrayList(storage.getEntries());
        for (StackListEntry entry : entries) {
            StackListResult<ItemStack> remainder;
            StackListResult extracted = storage.extract((ItemStack)entry.getStack(), this.upgrades.getItemInteractCount(), this.config.getCompare(), Action.SIMULATE);
            if (extracted == null || (remainder = this.network.insertItem((ItemStack)extracted.getStack(), extracted.getCount(), Action.SIMULATE)) != null) continue;
            return false;
        }
        return true;
    }

    private void extractItemFromNetwork(IStorageDisk<ItemStack> storage, int slot) {
        StackListResult<ItemStack> extracted = null;
        int i = 0;
        if (this.config.isItemFilterEmpty()) {
            ItemStack toExtract = null;
            ObjectArrayList networkItems = new ObjectArrayList(this.network.getItemStorageCache().getList().getStacks());
            int j = 0;
            while ((toExtract == null || toExtract.func_190926_b()) && j < networkItems.size()) {
                toExtract = (ItemStack)((StackListEntry)networkItems.get(j++)).getStack();
            }
            if (toExtract != null) {
                extracted = this.network.extractItem(toExtract, (long)this.upgrades.getItemInteractCount(), this.config.getCompare(), Action.PERFORM);
            }
        } else {
            while (this.config.getItemHandler().getSlots() > i && extracted == null) {
                ItemStack filterStack = ItemStack.field_190927_a;
                while (this.config.getItemHandler().getSlots() > i && filterStack.func_190926_b()) {
                    filterStack = this.config.getItemHandler().getStackInSlot(i++);
                }
                if (filterStack.func_190926_b()) continue;
                extracted = this.network.extractItem(filterStack, (long)this.upgrades.getItemInteractCount(), this.config.getCompare(), Action.PERFORM);
            }
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        StackListResult remainder = storage.insert((ItemStack)extracted.getStack(), extracted.getCount(), Action.PERFORM);
        if (remainder != null) {
            this.network.insertItem((ItemStack)remainder.getStack(), remainder.getCount(), Action.PERFORM);
        }
    }

    private void insertFluidIntoNetwork(IStorageDisk<FluidStack> storage, int slot) {
        if (this.network == null) {
            return;
        }
        ArrayList entries = new ArrayList(storage.getEntries());
        StackListResult extracted = null;
        int i = 0;
        while (extracted == null && entries.size() > i) {
            StackListEntry stack = (StackListEntry)entries.get(i++);
            extracted = storage.extract((FluidStack)stack.getStack(), this.upgrades.getItemInteractCount(), this.config.getCompare(), Action.PERFORM);
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        StackListResult<FluidStack> remainder = this.network.insertFluid((FluidStack)extracted.getStack(), extracted.getCount(), Action.PERFORM);
        if (remainder != null) {
            storage.insert(remainder.getStack(), remainder.getCount(), Action.PERFORM);
        }
    }

    private boolean isFluidDiskDone(IStorageDisk<FluidStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0L) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ObjectArrayList entries = new ObjectArrayList(storage.getEntries());
        for (StackListEntry entry : entries) {
            StackListResult<FluidStack> remainder;
            StackListResult extracted = storage.extract((FluidStack)entry.getStack(), this.upgrades.getItemInteractCount(), this.config.getCompare(), Action.SIMULATE);
            if (extracted == null || (remainder = this.network.insertFluid((FluidStack)extracted.getStack(), extracted.getCount(), Action.SIMULATE)) != null) continue;
            return false;
        }
        return true;
    }

    private void extractFluidFromNetwork(IStorageDisk<FluidStack> storage, int slot) {
        if (this.network == null) {
            return;
        }
        FluidStack extracted = null;
        int i = 0;
        if (this.config.isFluidFilterEmpty()) {
            FluidStack toExtract = null;
            ObjectArrayList networkFluids = new ObjectArrayList(this.network.getFluidStorageCache().getList().getStacks());
            int j = 0;
            while ((toExtract == null || toExtract.amount == 0) && j < networkFluids.size()) {
                toExtract = (FluidStack)((StackListEntry)networkFluids.get(j++)).getStack();
            }
            if (toExtract != null) {
                extracted = this.network.extractFluid(toExtract, this.upgrades.getItemInteractCount(), this.config.getCompare(), Action.PERFORM);
            }
        } else {
            while (this.config.getFluidHandler().getSlots() > i && extracted == null) {
                FluidStack filterStack = null;
                while (this.config.getFluidHandler().getSlots() > i && filterStack == null) {
                    filterStack = this.config.getFluidHandler().getFluid(i++);
                }
                if (filterStack == null) continue;
                extracted = this.network.extractFluid(filterStack, this.upgrades.getItemInteractCount(), this.config.getCompare(), Action.PERFORM);
            }
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        StackListResult<Object> remainder = storage.insert(extracted, extracted.amount, Action.PERFORM);
        if (remainder != null) {
            this.network.insertFluid((FluidStack)remainder.getStack(), remainder.getCount(), Action.PERFORM);
        }
    }

    private void moveDriveToOutput(int slot) {
        ItemStack disk = this.inputDisks.getStackInSlot(slot);
        if (!disk.func_190926_b()) {
            int i;
            for (i = 0; i < 3 && !this.outputDisks.getStackInSlot(i).func_190926_b(); ++i) {
            }
            if (i == 3) {
                return;
            }
            this.inputDisks.extractItem(slot, 1, false);
            this.outputDisks.insertItem(i, disk, false);
        }
    }

    public int getIoMode() {
        return this.ioMode;
    }

    public void setIoMode(int ioMode) {
        this.ioMode = ioMode;
    }

    public IItemHandler getInputDisks() {
        return this.inputDisks;
    }

    public IItemHandler getOutputDisks() {
        return this.outputDisks;
    }

    public ItemHandlerProxy getDisks() {
        return this.disks;
    }

    public IStorageDisk<ItemStack>[] getItemDisks() {
        return this.itemDisks;
    }

    public IStorageDisk<FluidStack>[] getFluidDisks() {
        return this.fluidDisks;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 3, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.inputDisks, 4, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.outputDisks, 5, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 3, tag);
        StackUtils.writeItems((IItemHandler)this.inputDisks, 4, tag);
        StackUtils.writeItems((IItemHandler)this.outputDisks, 5, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_IO_MODE, this.ioMode);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_IO_MODE)) {
            this.ioMode = tag.func_74762_e(NBT_IO_MODE);
        }
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputDisks, this.outputDisks, this.upgrades});
    }

    @Override
    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }

    @Override
    public ItemHandlerUpgrade getUpgradeHandler() {
        return this.upgrades;
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }
}

